
if (SERVER) then

	AddCSLuaFile( "shared.lua" )
	SWEP.Weight				= 5
	SWEP.AutoSwitchTo		= false
	SWEP.AutoSwitchFrom		= false

end

if ( CLIENT ) then

	SWEP.DrawAmmo			= true
	SWEP.DrawCrosshair		= false
	SWEP.ViewModelFOV		= 90
	SWEP.ViewModelFlip		= false

	CreateClientConVar( "kp_crosshair", 1 )
	CreateClientConVar( "kp_jumpsound", 1 )
	CreateClientConVar( "kp_hurtsounds", 1 )
		CreateClientConVar( "kp_gibbing", 1 )

	
end


SWEP.Contact		= ""
SWEP.Purpose		= ""
SWEP.Instructions	= ""

SWEP.Category		= "Kingpin"

SWEP.Spawnable			= false
SWEP.AdminSpawnable		= false

//SWEP.Primary.Sound			= Sound( "v_shotgunk/shotgload.wav" )
SWEP.Primary.Recoil			= 1.5
SWEP.Primary.Damage			= 40
SWEP.Primary.NumShots		= 1
SWEP.Primary.Cone			= 0.02
SWEP.Primary.Delay			= 0.15

SWEP.Primary.ClipSize		= -1
SWEP.Primary.DefaultClip	= -1
SWEP.Primary.Automatic		= false
SWEP.Primary.Ammo			= "none"

SWEP.Secondary.ClipSize		= -1
SWEP.Secondary.DefaultClip	= -1
SWEP.Secondary.Automatic	= false
SWEP.Secondary.Ammo			= "none"

SWEP.DrySound				= "weapons/v_pipebar/noammo.wav"

function SWEP:Initialize()

	if ( SERVER ) then
		self:SetNPCMinBurst( 30 )
		self:SetNPCMaxBurst( 30 )
		self:SetNPCFireRate( 0.01 )
	end
	
	self:SetWeaponHoldType( self.HoldType )
	util.PrecacheSound( self.Primary.Sound )
	util.PrecacheSound( self.DrySound )
	
end


function SWEP:Deploy()
	self.Weapon:SetNextPrimaryFire(CurTime() +.6)
	self.Weapon:SendWeaponAnim(ACT_VM_DRAW)

	return true
end

function SWEP:SecondaryAttack()	
end
function SWEP:Holster()

	return true
	end
function SWEP:Reload()
	if ( self.Weapon:Ammo1() <= 0 ) then return end
	if ( self.Weapon:Clip1() >= self.Primary.ClipSize ) then return end
	self.Weapon:DefaultReload( ACT_VM_RELOAD )
	self.Weapon:EmitSound(self.ReloadSound)
end

function SWEP:Think()
	self:Stuff()
	
	end

function SWEP:Stuff()
	for _,ply in pairs(player.GetAll()) do
	ply:SetDSP( 0 )
	end

end
function SWEP:OnRemove()

end

local GibModels = {"models/thug.mdl", "models/runt.mdl", "models/chick.mdl"}
local GibZones = {}
GibZones[1] = HITGROUP_HEAD
GibZones[4] = HITGROUP_LEFTARM
GibZones[5] = HITGROUP_RIGHTARM
GibZones[6] = HITGROUP_LEFTLEG
GibZones[7] = HITGROUP_RIGHTLEG
local GibInflictors =
{
	"kingpin_rpgk",
	"kp_rocket",
	"kingpin_launcher",
	"kp_grenade",
	"weapon_rpg",
	"rpg_missile",
	"weapon_grenade",
	"npc_grenade_frag",
	"grenade_ar2"
}

hook.Add("EntityTakeDamage", "ayy explosions", function(Ent, Info)
	if GetConVarNumber("kp_gibbing") == 1 then
if not IsValid(Ent) or (Ent:IsPlayer() or Ent:IsNPC()) == false then return end
if Ent:GetBloodColor() ~= BLOOD_COLOR_RED and Ent:GetBloodColor() ~= BLOOD_COLOR_ZOMBIE then return end
		local Attacker = Info:GetAttacker()
		if not IsValid(Attacker) or not Attacker:IsPlayer() then return end
		local Inflictor = Info:GetInflictor()
		if not IsValid(Inflictor) then return end
		if Inflictor:IsPlayer() then
			Inflictor = Attacker:GetActiveWeapon()
			if not IsValid(Inflictor) then return end
		end
		Inflictor = Inflictor:GetClass()
		local HitBodyGroup = nil
		if Ent:IsPlayer() then
			local EntModel = Ent:GetModel()
			for i = 1, #GibModels do
				if EntModel == GibModels[i] then
					for BodyGroup, HitGroup in pairs(GibZones) do
						if HitGroup == Ent:LastHitGroup() then
							HitBodyGroup = BodyGroup
							Ent.kp_LimbDamage = Ent.kp_LimbDamage or {}
							Ent.kp_LimbDamage[HitGroup] = (Ent.kp_LimbDamage[HitGroup] or 0) + Info:GetDamage()
							break
						end
					end
					break
				end
			end
		end
		local IsGibInflictor = false
		for i = 1, #GibInflictors do
			if Inflictor == GibInflictors[i] then
				IsGibInflictor = true
				break
			end
		end
		local GibAll = (IsGibInflictor and ((Ent:IsPlayer() and Info:GetDamage() > 70) or (Ent:IsNPC() and Info:GetDamage() > 50)))
		local GibLimb = not GibAll and HitBodyGroup and Ent.kp_LimbDamage[Ent:LastHitGroup()] > 40
		if Ent:Health() - Info:GetDamage() <= 0 and (GibAll or GibLimb) then
			Ent:EmitSound("kp/jibs.wav", 100, math.random(95, 105))
			if GibAll then
				if Ent:IsPlayer() then
					Ent:KillSilent()
				else
					Ent:Remove()
				end
			elseif GibLimb then
				Ent:SetBodygroup(HitBodyGroup, 1)
				if HitBodyGroup == 1 then
					Ent:SetBodygroup(2, 0)
					Ent:SetBodygroup(3, 0)
				end
			end
			for i = 0, (GibAll and math.random(5, 10) or ((GibLimb and HitBodyGroup == 1) and math.random(4, 6) or math.random(2, 4))) do
				local Bits = ents.Create("kp_bits")
				Bits:SetPos(Info:GetDamagePosition())
				Bits:Spawn()
				Bits:Activate()
				Bits:SetVelocity(Info:GetDamageForce() * Info:GetDamage() / (GibAll and 2 or 4) + VectorRand() * 10)
			end
		end
	end
end)
function SWEP:ShootBullet(dmg, numbul, cone, ric)
	numbul 	= numbul 	or 1
	cone 	= cone 		or 0.01

	local bullet = {}
	bullet.Num 		= numbul
	bullet.Src 		= self.Owner:GetShootPos()
	bullet.Dir 		= self.Owner:GetAimVector()
	bullet.Spread 	= Vector(cone, cone, 0)
	bullet.Tracer	= 4
	bullet.Force	= 4
	bullet.Damage	= dmg
	if ric == 1 then
		bullet.Callback	= Ricochet
	end
	
	self.Owner:FireBullets(bullet)
	self.Weapon:SendWeaponAnim(ACT_VM_PRIMARYATTACK)
	self.Owner:SetAnimation(PLAYER_ATTACK1)
end

function SWEP:CanPrimaryAttack()
	if ( self:Clip1() <= 0 ) then
 
		self:DryFire()
		self:SetNextPrimaryFire( CurTime() + 0.3 )
		self:Reload()
		return false
 
	end
 
	return true
end
local Ricochet = function(attacker, tr, dmginfo)
	if CLIENT then return end
	if tr.HitWorld and !tr.HitSky then
		sound.Play("weapons/ric"..math.random(1,3)..".wav", tr.HitPos, 75, 100)
	end
	return true
end


if CLIENT then
	local ch1 = surface.GetTextureID("sprites/kpsprites/ch1")
	local ch2 = surface.GetTextureID("sprites/kpsprites/ch2")
	local ch3 = surface.GetTextureID("sprites/kpsprites/ch3")

	function SWEP:DrawHUD()

		local x, y

		if ( self.Owner == LocalPlayer() && self.Owner:ShouldDrawLocalPlayer() ) then

			local tr = util.GetPlayerTrace( self.Owner )
			local trace = util.TraceLine( tr )
			
			local coords = trace.HitPos:ToScreen()
			x, y = coords.x, coords.y

		else
			x, y = ScrW() / 2.0, ScrH() / 2.0
		end
		
		local scale = .2
		
		local LastShootTime = self.Weapon:GetNetworkedFloat( "LastShootTime", 0 )
		scale = scale * (2 - math.Clamp( (CurTime() - LastShootTime) * 5, 0.0, 1.0 ))
		
		if GetConVarNumber( "kp_crosshair" ) == 1 then
		surface.SetTexture( ch1 )
		surface.SetDrawColor( 255, 255, 255, 255 )
		surface.DrawTexturedRect(x - 25, y - 25, 50, 50)
		elseif GetConVarNumber( "kp_crosshair" ) == 2 then
		surface.SetTexture( ch2 )
		surface.SetDrawColor( 255, 255, 255, 255 )
		surface.DrawTexturedRect(x - 25, y - 25, 50, 50)
		elseif GetConVarNumber( "kp_crosshair" ) == 3 then
		surface.SetTexture( ch3 )
		surface.SetDrawColor( 255, 255, 255, 255 )
		surface.DrawTexturedRect(x - 25, y - 25, 50, 50)
		

		end
	end
end

function SWEP:OnRestore()

	self.NextSecondaryAttack = 0
	
end



/*hook.Add("OnDamagedByExplosion", "PlayerDamage", function( pl, dmginfo )
    for _,ply in pairs(player.GetAll()) do
	local dmginfo = DamageInfo()
	dmginfo:SetDamage( 0 )
	dmginfo:SetAttacker( ply )
	dmginfo:SetInflictor( ply )
	ply:TakeDamageInfo( dmginfo )
	end
	end
end)*/